/*
	Copyright  1995-2002, The AROS Development Team. All rights reserved.
	$Id: pc104_gr.c,v 1.3 2011/01/22 14:21:47 krashan Exp $

	Desc: US PC104/PC101 Keymap
	Lang: English
*/

#include <devices/keymap.h>

#define	VERSION		51
#define	REVISION	4
#define	KMDESC		"Greek keyboard with 101/104 keys"
#define	KMID		"pc104_gr 51.4"
#define KMNAME		"pc104_gr"
#define KMLANG      "Greek"
#define KMLANGINT   "Greek"
#define KMCODEPAGE  "ISO-8859-7"

#define CONST const

extern CONST char  keymapname[];

extern CONST UBYTE lokeymaptypes[];
extern CONST IPTR  lokeymap[];
extern CONST UBYTE locapsable[];
extern CONST UBYTE lorepeatable[];

extern CONST UBYTE hikeymaptypes[];
extern CONST IPTR  hikeymap[];
extern CONST UBYTE hicapsable[];
extern CONST UBYTE hirepeatable[];

static const struct Resident ROMTag;

struct ExtendedKeyMapNode km =
{
	{
	NULL, NULL, NT_EXTENDED, 'E', (char*) keymapname
	},
	{
	(UBYTE *)lokeymaptypes,
	(IPTR  *)lokeymap,
	(UBYTE *)locapsable,
	(UBYTE *)lorepeatable,
	(UBYTE *)hikeymaptypes,
	(IPTR  *)hikeymap,
	(UBYTE *)hicapsable,
	(UBYTE *)hirepeatable
	},
	0,
	(struct Resident *)&ROMTag,
	0
};

CONST char keymapname[] = KMNAME;

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#define N KC_NOQUAL
#define S KCF_SHIFT
#define A KCF_ALT
#define C KCF_CONTROL
#define D KCF_DEAD
#define V KC_VANILLA
#define ST KCF_STRING
#define NOP KCF_NOP

#define EUR 0xA4 /* ISO 8859-15: Euro = 164 = 0xA4) */

CONST UBYTE lokeymaptypes[] =
{
	S|C,	/* 00 */
	V,		/* 01 */
	V,		/* 02 */
	V,		/* 03 */
	V,		/* 04 */
	V,		/* 05 */
	V,		/* 06 */
	V,		/* 07 */
	V,		/* 08 */
	V,		/* 09 */
	V,		/* 0A */
	S|C,	/* 0B */
	S|C,	/* 0C */
	S|C,	/* 0D */
	N,		/* 0E */
	N,		/* 0F */
	V,		/* 10 q */
	V,		/* 11 w */
	D|V,	/* 12 e */
	V,		/* 13 r */
	V,		/* 14 t */
	D|V,	/* 15 y */
	D|V,	/* 16 u */
	D|V,	/* 17 i */
	D|V,	/* 18 o */
	V,		/* 19 p */
	V,		/* 1A */
	V,		/* 1B */
	N,		/* 1C */
	N,		/* 1D */
	N,		/* 1E */
	N,		/* 1F */
	D|V,	/* 20 a */
	V,		/* 21 s */
	V,		/* 22 d */
	D|V,	/* 23 f */
	D|V,	/* 24 g */
	D|V,	/* 25 h */
	D|V,	/* 26 j */
	D|V,	/* 27 k */
	V,		/* 28 l */
	S|C,	/* 29 */
	S|C,	/* 2A */
	S|C,	/* 2B */
	N,		/* 2C */
	N,		/* 2D */
	N,		/* 2E */
	N,		/* 2F */
	V,		/* 30 */
	V,		/* 31 z */
	V,		/* 32 x */
	V,		/* 33 c */
	V,		/* 34 v */
	V,		/* 35 b */
	D|V,	/* 36 n */
	V,		/* 37 m */
	S|C,	/* 38 */
	S|C,	/* 39 */
	S|C,	/* 3A */
	N,		/* 3B */
	N,		/* 3C */
	N,		/* 3D */
	N,		/* 3E */
	N,		/* 3F */

};

CONST UBYTE hikeymaptypes[] =
{
	D|A,	/* 40 SPACE */
	N,		/* 41 BACKSPACE */
	ST|S,	/* 42 TAB */
	N,		/* 43 ENTER */
	C,		/* 44 RETURN */
	A,		/* 45 ESCAPE */
	N,		/* 46 DEL  */
	ST|S,	/* 47 INSERT ?? */
	ST|S,	/* 48 PAGE UP ?? */
	ST|S,	/* 49 PAGE DOWN ?? */
	N,		/* 4A NUMERIC PAD - */
	ST|S,	/* 4B F11 ?? */
	ST|S,	/* 4C CURSORUP*/
	ST|S,	/* 4D CURSORDOWN */
	ST|S,	/* 4E CURSORRIGHT */
	ST|S,	/* 4F CURSORLEFT */
	ST|S,	/* 50 F1 */
	ST|S,	/* 51 F2 */
	ST|S,	/* 52 F3 */
	ST|S,	/* 53 F4 */
	ST|S,	/* 54 F5 */
	ST|S,	/* 55 F6 */
	ST|S,	/* 56 F7 */
	ST|S,	/* 57 F8 */
	ST|S,	/* 58 F9 */
	ST|S,	/* 59 F10 */
	NOP,	/* 5A NUMLOCK */
	N,		/* 5B NUMPAD ) */
	N,		/* 5C NUMPAD / */
	N,		/* 5D NUMPAD * */
	N,		/* 5E NUMPAD + */
	ST,		/* 5F HELP */
	NOP,	/* 60 LEFT SHIFT*/
	NOP,	/* 61 RIGHT SHIFT */
	NOP,	/* 62 CAPS LOCK */
	NOP,	/* 63 CONTROL */
	NOP,	/* 64 LALT */
	NOP,	/* 65 RALT */
	NOP,	/* 66 LCOMMAND */
	NOP,	/* 67 RCOMMAND */
	NOP,	/* 68 LEFT MOUSE BUTTON*/
	NOP,	/* 69 RIGHT MOUSE BUTTON */
	NOP,	/* 6A MIDDLE MOUSE BUTTON */
	ST|S,	/* 6B SCR LOCK */
	ST|S,	/* 6C PRT SCREEN */
	ST|S,	/* 6D NUM LOCK */
	ST|A,	/* 6E PAUSE/BREAK ??*/
	ST|S,	/* 6F F12 ?? */
	ST|C,	/* 70 HOME ?? */
	ST|C,	/* 71 END ?? */
	NOP,	/* 72 */
	NOP,	/* 73 */
	NOP,	/* 74 */
	NOP,	/* 75 */
	NOP,	/* 76 */
	NOP,	/* 77 */
	NOP,	/* 78 */
	NOP,	/* 79 */
	NOP,	/* 7A */
	NOP,	/* 7B */
	NOP,	/* 7C */
	NOP,	/* 7D */
	NOP,	/* 7E */
	NOP		/* 7F */

};

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#undef STRING
#undef DEAD
#undef BYTES

#define STRING(x) (IPTR)(x)
#define DEAD(x)	  (IPTR)(x)
#define BYTES(b0, b1, b2, b3) \
	(((UBYTE)(b3))<<0) | (((UBYTE)(b2))<<8) | (((UBYTE)(b1))<<16) | (((UBYTE)(b0))<<24)

#define N 0
#define D DPF_DEAD
#define M DPF_MOD

const UBYTE key12_descr[] =
{
	M, 16, M, 22,
	N, 0xa4, N, 0xa9,
	N, 0x05, N, 0x05,
	N, 0x85, N, 0x85,
	'e', 0xe9, 0xe8, 0xea, 'e', 0xeb,
	'E', 0xc9, 0xc8, 0xca, 'E', 0xcb,
};

const UBYTE key15_descr[] =
{
	M, 16, M, 22,
	N, 0xa4, N, 0xa5,
	N, 0x19, N, 0x19,
	N, 0x99, N, 0x99,
	'y', 0xfd, 'y', 'y', 'y', 0xff,
	'Y', 0xdd, 'Y', 'Y', 'Y', 'Y',
};

const UBYTE key16_descr[] =
{
	M, 16, M, 22,
	N, 0xb5, N, 0xb5,
	N, 0x15, N, 0x15,
	N, 0x95, N, 0x95,
	'u', 0xfa, 0xf9, 0xfb, 'u', 0xfc,
	'U', 0xda, 0xd9, 0xdb, 'U', 0xdc,
};

const UBYTE key17_descr[] =
{
	M, 16, M, 22,
	N, 0xa1, N, 0xa6,
	N, 0x09, N, 0x09,
	N, 0x89, N, 0x89,
	'i', 0xed, 0xec, 0xee, 'i', 0xef,
	'I', 0xcd, 0xcc, 0xce, 'I', 0xcf,
};

const UBYTE key18_descr[] =
{
	M, 16, M, 22,
	N, 0xf8, N, 0xd8,
	N, 0x0f, N, 0x0f,
	N, 0x8f, N, 0x8f,
	'o', 0xf3, 0xf2, 0xf4, 0xf5, 0xf6,
	'O', 0xd3, 0xd2, 0xd4, 0xd5, 0xd6,
};

const UBYTE key20_descr[] =
{
	M, 16, M, 22,
	N, 0xe6, N, 0xc6,
	N, 0x01, N, 0x01,
	N, 0x81, N, 0x81,
	'a', 0xe1, 0xe0, 0xe2, 0xe3, 0xe4,
	'A', 0xc1, 0xc0, 0xc2, 0xc3, 0xc4,
};

const UBYTE key23_descr[] =
{
	N, 'f', N, 'F',
	D, 1, D, 1,
	N, 0x06, N, 0x06,
	N, 0x86, N, 0x86,
};

const UBYTE key24_descr[] =
{
	N, 'g', N, 'G',
	D, 2, D, 2,
	N, 0x07, N, 0x07,
	N, 0x87, N, 0x87,
};

const UBYTE key25_descr[] =
{
	N, 'h', N, 'H',
	D, 3, D, 3,
	N, 0x08, N, 0x08,
	N, 0x88, N, 0x88,
};

const UBYTE key26_descr[] =
{
	N, 'j', N, 'J',
	D, 4, D, 4,
	N, 0x0a, N, 0x0a,
	N, 0x8a, N, 0x8a,
};

const UBYTE key27_descr[] =
{
	N, 'k', N, 'K',
	D, 5, D, 5,
	N, 0x0b, N, 0x0b,
	N, 0x8b, N, 0x8b,
};

const UBYTE key36_descr[] =
{
	M, 16, M, 22,
	N, 0xad, N, 0xaf,
	N, 0x0e, N, 0x0e,
	N, 0x8e, N, 0x8e,
	'n', 'n', 'n', 'n', 0xf1, 'n',
	'N', 'N', 'N', 'N', 0xd1, 'N',
};

const UBYTE key40_descr[] =
{
	M, 4,
	N, 0xa0,
	' ', 0xb4, '`', '^', '~', 0xa8,
};

CONST IPTR lokeymap[] =
{
	BYTES('~', '`', '~', '`'),		/* 00 Left of 1 Key */
	BYTES('', '!', '!', '1'),		/* 01 1 */
	BYTES('', '@', '@', '2'),		/* 02 2 */
	BYTES('', '#', '#', '3'),		/* 03 3 */
	BYTES('', '$', '$', '4'),		/* 04 4 */
	BYTES('', '%', '%', '5'),		/* 05 5 */
	BYTES('', '^', '^', '6'),		/* 06 6 */
	BYTES('', '&', '&', '7'),		/* 07 7 */
	BYTES('', '*', '*', '8'),		/* 08 8 */
	BYTES('', '(', '(', '9'),		/* 09 9 */
	BYTES('', ')', ')', '0'),		/* 0A 0 */
	BYTES('_', '-', '_', '-'),		/* 0B Right of 0 */
	BYTES('+', '=', '+', '='),		/* 0C 2nd right of 0 */
	BYTES('|', '\\', '|', '\\'),    /* 0D 3rd right of 0 */
	BYTES(0, 0, 0, 0),			      /* 0E undefined */
	BYTES('0', '0', '0', '0'),		/* 0F NUM 0 */
	BYTES(197, 229, 'Q', 'q'),		/* 10 */
	BYTES(176, 176, 'W', 'w'),		/* 11 */
	DEAD(key12_descr),			      /* 12 */
	BYTES(174, 174, 'R', 'r'),		/* 13 */
	BYTES(222, 254, 'T', 't'),		/* 14 */
	DEAD(key15_descr),			      /* 15 */
	DEAD(key16_descr),			      /* 16 */
	DEAD(key17_descr),			      /* 17 */
	DEAD(key18_descr),			      /* 18 */
	BYTES(182, 182, 'P', 'p'),		/* 19 */

	BYTES('{', '[', '{', '['),		/* 1A */
	BYTES('}', ']', '}', ']'),		/* 1B */
	BYTES(0, 0, 0, 0),			      /* 1C undefined */
	BYTES('1', '1', '1', '1'),		/* 1D NUM 1*/
	BYTES('2', '2', '2', '2'),		/* 1E NUM 2*/
	BYTES('3', '3', '3', '3'),		/* 1F NUM 3*/

	DEAD(key20_descr),			      /* 20 */
	BYTES(167, 223, 'S', 's'),		/* 21 */
	BYTES(208, 240, 'D', 'd'),		/* 22 */
	DEAD(key23_descr),			/* 23 */
	DEAD(key24_descr),			/* 24 */
	DEAD(key25_descr),			/* 25 */
	DEAD(key26_descr),			/* 26 */
	DEAD(key27_descr),			/* 27 */
	BYTES(163, 163, 'L', 'l'),		/* 28 */

	BYTES(':', ';', ':', ''),		/* 29 */
	BYTES('"','\'', '"','\''),		/* 2A */
	BYTES('|','\\', '|','\\'),		/* 2B */
	BYTES(0, 0, 0, 0),			      /* 2C undefined */
	BYTES('4', '4', '4', '4'),		/* 2D NUM 4 */
	BYTES('5', '5', '5', '5'),		/* 2E NUM 5 */
	BYTES('6', '6', '6', '6'),		/* 2F NUM 6 */
	BYTES('|', '\\', '>', '<'),		/* 30 */
	BYTES(172, 177, 'Z', 'z'),		/* 31 */
	BYTES(247, 215, 'X', 'x'),		/* 32 */
	BYTES(199, 231, 'C', 'c'),		/* 33 */
	BYTES(170, 170, 'V', 'v'),		/* 34 */
	BYTES(186, 186, 'B', 'b'),		/* 35 */
	DEAD(key36_descr),			      /* 36 */
	BYTES(191, 184, 'M', 'm'),		/* 37 */

	BYTES('<', ',', '<', ','),		/* 38 */
	BYTES('>', '.', '>', '.'),		/* 39 */
	BYTES('?', '/', '?', '/'),		/* 3A */
	BYTES(0, 0, 0, 0),	/* 3B */
	BYTES('.', '.', '.', '.'),		/* 3C NUM . */
	BYTES('7', '7', '7', '7'),		/* 3D NUM 7 */
	BYTES('8', '8', '8', '8'),		/* 3E NUM 8 */
	BYTES('9', '9', '9', '9'),		/* 3F NUM 9 */
};

#include "standard.h"

CONST IPTR hikeymap[] =
{
	DEAD(key40_descr),		/* 40 SPACE */
	BYTES(8, 8, 8, 8),		/* 41 BACKSPACE*/
	STRING(tab_descr),		/* 42 TAB */
	BYTES(13, 13, 13, 13),	/* 43 ENTER */
	BYTES(0, 0, 10, 13),	/* 44 RETURN */
	BYTES(0, 0, 0x9B, 27),	/* 45 ESCAPE */
	BYTES(127, 127, 127, 127),	/* 46 DEL */
	STRING(insert_descr),	/* 47 INSERT ?? */
	STRING(pageup_descr),	/* 48 PAGEUP ?? */
	STRING(pagedown_descr),	/* 49 PAGEDOWN ?? */
	BYTES('-', '-', '-', '-'),	/* 4A NUMPAD - */
	STRING(f11_descr),		/* 4B F11 ?? */
	STRING(up_descr),		/* 4C CURSOR UP*/
	STRING(down_descr),		/* 4D CURSOR DOWN*/
	STRING(right_descr),	/* 4E CURSOR RIGHT */
	STRING(left_descr),		/* 4F CURSOR LEFT */
	STRING(f1_descr),		/* 50 F1 */
	STRING(f2_descr),		/* 51 */
	STRING(f3_descr),		/* 52 */
	STRING(f4_descr),		/* 53 */
	STRING(f5_descr),		/* 54 */
	STRING(f6_descr),		/* 55 */
	STRING(f7_descr),		/* 56 */
	STRING(f8_descr),		/* 57 */
	STRING(f9_descr),		/* 58 */
	STRING(f10_descr),		/* 59 */
	BYTES(0, 0, 0, 0),		/* 5A */
	BYTES(0, 0, 0, 0),		/* 5B */
	BYTES('/', '/', '/', '/'),	/* 5C */
	BYTES('*', '*', '*', '*'),	/* 5D */
	BYTES('+', '+', '+', '+'),	/* 5E */
	STRING(help_descr),		/* 5F HELP */
	BYTES(0, 0, 0, 0),		/* 60 */
	BYTES(0, 0, 0, 0),		/* 61 */
	BYTES(0, 0, 0, 0),		/* 62 */
	BYTES(0, 0, 0, 0),		/* 63 */
	BYTES(0, 0, 0, 0),		/* 64 */
	BYTES(0, 0, 0, 0),		/* 65 */
	BYTES(0, 0, 0, 0),		/* 66 */
	BYTES(0, 0, 0, 0),		/* 67 */
	BYTES(0, 0, 0, 0),		/* 68 */
	BYTES(0, 0, 0, 0),		/* 69 */
	BYTES(0, 0, 0, 0),		/* 6A */
	STRING(scrlck_descr),	/* 6B */
	STRING(prtsc_descr),	/* 6C */
	STRING(numlock_descr),	/* 6D */
	STRING(pausebreak_descr),	/* 6E PAUSE/BREAK ?? */
	STRING(f12_descr),		/* 6F F12 ?? */
	STRING(home_descr),		/* 70 HOME ?? */
	STRING(end_descr),		/* 71 END ?? */
	BYTES(0, 0, 0, 0),		/* 72 */
	BYTES(0, 0, 0, 0),		/* 73 */
	BYTES(0, 0, 0, 0),		/* 74 */
	BYTES(0, 0, 0, 0),		/* 75 */
	BYTES(0, 0, 0, 0),		/* 76 */
	BYTES(0, 0, 0, 0),		/* 77 */
	BYTES(0, 0, 0, 0),		/* 78 */
	BYTES(0, 0, 0, 0),		/* 79 */
	BYTES(0, 0, 0, 0),		/* 7A */
	BYTES(0, 0, 0, 0),		/* 7B */
	BYTES(0, 0, 0, 0),		/* 7C */
	BYTES(0, 0, 0, 0),		/* 7D */
	BYTES(0, 0, 0, 0),		/* 7E */
	BYTES(0, 0, 0, 0),		/* 7F */
};

#undef SETBITS

#define SETBITS(b0, b1, b2, b3, b4, b5, b6, b7) \
	(b0<<0)|(b1<<1)|(b2<<2)|(b3<<3)|(b4<<4)|(b5<<5)|(b6<<6)|(b7<<7)

CONST UBYTE locapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 00 - 07 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 08 - 0F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 0, 0, 0, 0, 0, 0),	/* 18 - 1F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 0, 0, 0, 0, 0, 0, 0),	/* 28 - 2F */

	SETBITS(0, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 38 - 3F */
};

CONST UBYTE hicapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 40 - 47 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 48 - 4F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 58 - 5F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

CONST UBYTE lorepeatable[] =
{
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
	SETBITS(1, 1, 1, 1, 1, 1, 0, 1),	/* 08 - 0F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 18 - 1F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 28 - 2F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1)	/* 38 - 3F */
};

CONST UBYTE hirepeatable[] =
{
	SETBITS(1, 1, 1, 0, 0, 0, 1, 0),	/* 40 - 47 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1),	/* 48 - 4F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 1, 1, 1, 1, 1, 0),	/* 58 - 5F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

#define HAVE_UNICODE_CONVTABLE 1
#define HAVE_CHARSET_CONVTABLE 1

STATIC CONST ULONG unicodetable[] =
{
	// 0xA1 - 0xAF
	        0x2018, 0x2019, 0x00a3, 0x20ac, 0x20af, 0x00a6, 0x00A7,
	0x00A8, 0x00a9, 0x037a, 0x00ab, 0x00ac, 0x00AD, 0x00ae, 0x2015,

	// 0xB0 - 0xBF
	0x00B0, 0x00b1, 0x00b2, 0x00b3, 0x0384, 0x0385, 0x0386, 0x00b7,
	0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f,

	// 0xC0 - 0xCF
	0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
	0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,

	// 0xD0 - 0xDF
	0x03a0, 0x03a1, 0x00d2, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7,
	0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af,

	// 0xE0 - 0xEF
	0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
	0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,

	// 0xF0 - 0xFF
	0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
	0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce
};

STATIC CONST struct UCS4_ConvTable convtable =
{
	0xA1,
	0xFE,
	unicodetable
};

STATIC CONST UBYTE chartable1[] =
{
	// 0x384 - 0x38f
	0xb4, 0xb5, 0xb6, '?', 0xb8, 0xb9, 0xba, '?', 0xbc, '?', 0xbe, 0xbf,
	// 0x390 - 0x397
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	// 0x398 - 0x39f
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	// 0x3a0 - 0x3a7
	0xd0, 0xd1, '?', 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	// 0x3a8 - 0x3af
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	// 0x3b0 - 0x3b7
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	// 0x3b8 - 0x3bf
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	// 0x3c0 - 0x3c7
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	// 0x3c8 - 0x3ce
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe
};

STATIC CONST UBYTE chartable2[] =
{
	// 0x2015 - 0x2019
	0xaf, '?', '?', 0xa1, 0xa2
};

STATIC CONST struct UCS4_CharsetCode convtab[] =
{
	{ 0x037a, 0xaa },
	{ 0x20ac, 0xa4 },
	{ 0x20af, 0xa5 },
	{ 0x0000, 0x00 },
};

STATIC CONST struct UCS4_CharsetConvTable convtable2 =
{
	convtab,

	{
		{ 0x0384, 0x03ce, chartable1 },
		{ 0x2015, 0x20af, chartable2 },
		{ 0x0000, 0x0000, NULL }
	}
};

#include "query.c"
